# RMT Modélisation & Analyse de Données - Atelier Série temporelle 10 juillet 2014
# David Makowski (INRA)

library(tseries)
library(dlm)
library(ZeBook)
################################################################################                               
#Data for Wheat Yield in Greece
TAB_Yield<-read.table("table_wheat_eure_et_loir.txt", header=T)
Year<-TAB_Yield[,1]
Yield<-TAB_Yield[,2]

TAB_Yield<-read.table("table_wheat_pyrenees_atlantiques.txt", header=T)
Year<-TAB_Yield[,1]
Yield<-TAB_Yield[,4]

par(mfrow=c(1,1),oma=c(5,1,5,1))
plot(Year,Yield,ylab="Yield (t ha-1)", type="l",lwd=1)

################################################################################
#Definition of model 1
MyModel<-function(x) {
	return(dlmModPoly(1, dV=exp(x[1]), dW=exp(x[2])))
	}

#Estimation of parameters of the model
fitMyModel<-dlmMLE(Yield,parm=c(0,0), build=MyModel)
print(fitMyModel)

#aVar<-solve(fitMyModel$hessian)
#sqrt(diag(aVar))

#Filtrage, Lissage, Prediction

FittedModel<-MyModel(fitMyModel$par)
#FittedModel<-MyModel(c(0,-5))

YieldFilter<-dlmFilter(Yield, FittedModel)
YieldSmooth<-dlmSmooth(Yield, FittedModel)
YieldFilter_1<-YieldFilter

par(mfrow=c(1,1),oma=c(5,1,5,1))
plot(Year,Yield,ylab="Yield (t ha-1)", type="l",lwd=1)
lines(Year,YieldFilter$m[-1],lwd=2, lty=3)
lines(Year,YieldSmooth$s[-1],lwd=2)

################################################################################
#Definition of model 2
MyModel<-function(x) {
	return(dlmModPoly(2, dV=exp(x[1]), dW=c(exp(x[2]), exp(x[3]))))
	}

#Estimation of parameters of the model

fitMyModel<-dlmMLE(Yield,parm=c(0,0,0), build=MyModel)
print(fitMyModel)

#aVar<-solve(fitMyModel$hessian)
#sqrt(diag(aVar))

#Filtrage, Lissage, Prediction

FittedModel<-MyModel(fitMyModel$par)
#FittedModel<-MyModel(c(0,-5,-5))

YieldFilter<-dlmFilter(Yield, FittedModel)
YieldSmooth<-dlmSmooth(Yield, FittedModel)
YieldFilter_2<-YieldFilter

dev.new()
par(mfrow=c(1,1),oma=c(5,1,5,1))
plot(Year,Yield,ylab="Yield (t ha-1)", type="l",lwd=1)
lines(Year,YieldFilter$m[,1][-1]+YieldFilter$m[,2][-1],lwd=2, lty=3)
lines(Year,YieldSmooth$s[,1][-1]+YieldSmooth$s[,2][-1],lwd=2)

Trend<-YieldSmooth$s[,1][-1]+YieldSmooth$s[,2][-1]

################################################################################
#Extraction of variances of slops smoothed
Var<-dlmSvd2var(YieldSmooth$U.S,YieldSmooth$D.S)
Var.slope.sm<-rep(NA,(length(TAB_Yield[,1])+1))
for (i in 1:(length(TAB_Yield[,1])+1)) {
    Var.slope.sm[i]<-Var[[i]][2,2]
	}                                 

dev.new()
par(mfrow=c(1,1),oma=c(5,1,5,1))
plot(Year,YieldSmooth$s[,2][-1],ylab="Yield increase rate (t ha-1 year-1)", type="l",lwd=2,ylim=c(-0.025,0.25))
lines(Year,YieldSmooth$s[,2][-1]+qnorm(0.75)*sqrt(Var.slope.sm[-1]),lty=2)
lines(Year,YieldSmooth$s[,2][-1]-qnorm(0.75)*sqrt(Var.slope.sm[-1]),lty=2)

################################################################################
#Predictions for next 20 years
foreYield_1<-dlmForecast(YieldFilter_1,nAhead=20)
foreYield_2<-dlmForecast(YieldFilter_2,nAhead=20)

FuturYear<-seq(Year[length(TAB_Yield[,1])]+1,Year[length(TAB_Yield[,1])]+20)

dev.new()
par(mfrow=c(1,2),oma=c(5,1,5,1))
plot(FuturYear,foreYield_1$f,xlab="Year", ylab="Forecasted Yield (t ha-1)", ylim=c(2,10), type="l")
#Confidence intervals
lines(FuturYear,foreYield_1$f+qnorm(0.75)*sqrt(unlist(foreYield_1$Q)),lty=2)
lines(FuturYear,foreYield_1$f-qnorm(0.75)*sqrt(unlist(foreYield_1$Q)),lty=2)
title("A                              ")

plot(FuturYear,foreYield_2$f,xlab="Year", ylab="Forecasted Yield (t ha-1)", ylim=c(2,10), type="l")

#Confidence intervals
lines(FuturYear,foreYield_2$f+qnorm(0.75)*sqrt(unlist(foreYield_2$Q)),lty=2)
lines(FuturYear,foreYield_2$f-qnorm(0.75)*sqrt(unlist(foreYield_2$Q)),lty=2)
title("B                              ")

TABslopeFrance<-data.frame(Year,YieldSmooth$s[,2][-1],Var.slope.sm[-1])
names(TABslopeFrance)<-c("Year","Slope","VarSlope")

TABslopeFrance

