# RMT Modlisation & Analyse de Donnes - Atelier Srie temporelle 10 juillet 2014
# Juliette Adrian (INRA)
###########################################
#### COURBES : ESTIMATION / PREDICTION ####
###########################################


courbe <- function(variable,year,tab_obs,tab_calcul,P=F)
{

# Rcupration des donnes

tab_obs=read.table(tab_obs,h=T)
tab_calcul=read.table(tab_calcul,h=T)


tab_obs$Group <- as.factor(as.character(tab_obs$Group) )
tab_calcul$Group <- as.factor(as.character(tab_calcul$Group) )

l=0

  for(i in 1:length(levels(tab_obs$Group)) )                         # debut boucle pour chaque entit gographique
  {
    tab_i=subset(tab_obs,tab_obs$Group==levels(tab_obs$Group)[i])         # extraction des donnees pour la region
    Group_i=tab_i$Group
    tab_calcul_i=subset(tab_calcul,tab_calcul$Group==Group_i[1])
    
    if (all(is.na(tab_calcul_i$Y)))                        # si pas de donnees pour la region
      { print(Group_i[1])
        print("no data") 
        next }                                                       

    minYear_i=min(na.omit(tab_i)["Time"])
    maxYear_i=max(na.omit(tab_i)["Time"])
    
    tab_i= subset(tab_i,tab_i$Time<=maxYear_i & tab_i$Time>=minYear_i)

    
    tab_calcul_i=subset(tab_calcul_i,tab_calcul_i$Time<=year & tab_calcul_i$Time>=minYear_i)
    tab_estim_i=subset(tab_calcul_i,tab_calcul_i$Time<=maxYear_i)               # tableau des estimations
    tab_pred_i=subset(tab_calcul_i,tab_calcul_i$Time>=maxYear_i)                # tableau des predictions

    if (l%%4==0)                     # nouvelle fentre graphique toutes les 6 entits
    { dev.new() 
    par(mfrow=c(2,2)) }
    l=l+1

# Courbe pour estimation
    if (P==F)                                           # calcul des limites de y (rdt)
        {
            if (variable=="Y")
            {
        y_min_plot <- min(na.omit(tab_calcul_i[,variable]),na.omit(tab_i[,variable]))
        y_max_plot <- max(na.omit(tab_calcul_i[,variable]),na.omit(tab_i[,variable]))
            } else {                  
        y_min_plot <- min(na.omit(tab_calcul_i[,variable]))
        y_max_plot <- max(na.omit(tab_calcul_i[,variable]))      
        }} else {
        y_min_plot <- min(na.omit(tab_calcul_i[,variable]),na.omit(tab_i[,variable]),min(na.omit(tab_calcul_i[,P])))
        y_max_plot <- max(na.omit(tab_calcul_i[,variable]),na.omit(tab_i[,variable]),max(na.omit(tab_calcul_i[,P])))    
        }
        
        
    plot(tab_estim_i$Time,tab_estim_i[,variable],ylab=variable,xlab="Time", type="l",lwd=1, col = "black", col.lab = "black",xlim=c(minYear_i,year), ylim=c(y_min_plot,y_max_plot))
    title(Group_i[1])
    
    if (variable=="Y")          # ajout des observations de rendement si on represente Yield
    {
    points(tab_i$Time,tab_i$Y,pch=46)
    }
        
    if (year>maxYear_i)                         # ajout des prediction de la variable demande en rouge
      {
      lines(tab_pred_i$Time,tab_pred_i[,variable],col="red",lwd=1)          
      }    

    if (P==F)                                      
    { 
    next
    } else {
    for (k in 1:length(P))                               # ajout des percentiles
      {
         lines(tab_estim_i$Time,tab_estim_i[,P[k]],col="black",lty=2)     # estimes
         if (year>maxYear_i) 
        {                                                      
        lines(tab_pred_i$Time,tab_pred_i[,P[k]],col="red",lty=2)           # predits 
        }    
     }
    }
}       #fin de la boucle par entit


} #fin de la fonction
