# RMT Modlisation & Analyse de Donnes - Atelier Srie temporelle 10 juillet 2014
# Juliette Adrian (INRA)
###########################################
###### CALCULS : MODELES / ESTIMATIONS ####
###########################################


# Creation de la fonction

dlm_model <- function(perimeter,year,modeltype,vartype,datas,modelpath,bugspath,save_obs=F,save_calcul=F,nchains=3,niter=50000,nburnin=5000,nthin=10)  
{
# Chargement des packages

library(R2WinBUGS)

# I) Tableau d'observation

    # Lecture du tableau de donnees
    
  tab <-  read.table(datas,h=T)

    # Extraction des individus demandes

  if (perimeter=="all")
  { perimeter <- levels(tab$Group) }
    
  tab_obs <-subset(tab,tab$Group%in%perimeter)


# II) Modele

  tab_calcul=data.frame()              # cration du tableau de resultats
  tab_dic=data.frame()
  tab_pente=data.frame() 

  tab_obs$Group <- as.factor(as.character(tab_obs$Group) )

  for(i in 1:length(levels(tab_obs$Group)) )                         # debut boucle pour chaque entite geographique
  {
    
    tab_i=subset(tab_obs,tab_obs$Group==levels(tab_obs$Group)[i])        # tableau par entite
    tab_i=data.frame("Group"=tab_i$Group,"Time"=tab_i$Time,"Y"=tab_i$Y)
  diftab=year-tab_i$Time[1]+1  


    if (all(is.na(tab_i$Y))|length(tab_i$Time)!=(max(tab_i$Time)-min(tab_i$Time)+1))
      {   tab_calcul_i <-data.frame("Group"=rep.int(tab_i$Group[1],diftab),"Time"=c(tab_i$Time[1]:year),"Y"=NA,"Y_1"=NA,"Y_2.5"=NA,"Y_5"=NA,"Y_10"=NA,
      "Y_25"=NA,"Y_75"=NA,"Y_90"=NA,"Y_95"=NA,"Y_97.5"=NA,"Y_99"=NA,"y_1"=NA,"y_2.5"=NA,"y_5"=NA,"y_10"=NA,"y_25"=NA,
            "y_75"=NA,"y_90"=NA,"y_95"=NA,"y_97.5"=NA,"y_99"=NA,"sd_tot"=NA ,"sd_trend"=NA,"sd_res"=NA)
          tab_calcul <- rbind(tab_calcul,tab_calcul_i)
      next }                                                       

    minYear_i=min(na.omit(tab_i)["Time"])
    maxYear_i=max(na.omit(tab_i)["Time"])
    DifYear=year-minYear_i+1                       # calcul nombre d'annees a calculer (estimer et/ou predire)
    pred=year-maxYear_i
      

    tab_i= subset(tab_i,tab_i$Time<=maxYear_i & tab_i$Time>=minYear_i)    

                  if  (pred>0)
    {
    tab_NA=data.frame("Group"=rep(tab_i$Group[1],pred),"Time"=seq((maxYear_i+1),year),"Y"=rep(NA,pred))
    tab_i=rbind(tab_i,tab_NA) 
    }
    
    tab_i= subset(tab_i,tab_i$Time<=year & tab_i$Time>=minYear_i)      # tableau par entite pour les annees demandees
    

#DONNEES

    x <- tab_i$Y                                     # donnees pour WinBUGS
    n <- length(tab_i$Y)

    # 1) Modele sans pente
    
    if (modeltype==0)
      { 
      if (vartype=="var_cste")             # variance constante
          {
          data<-list(T=n,yield=x)
          vars2keep<-list("a","Y","tau.obs")
          inits<-function(){list(tau.state.a=0.1, tau.obs=0.1)}

          output<-bugs(
                    model.file=file.path(modelpath),                   # appel de WinBUGS
                    data=data,
                    inits = inits,
                    parameters.to.save =vars2keep,
                    n.chains=nchains,
                    n.iter=niter,
                    n.burnin=nburnin,
                    n.thin=nthin,
                    DIC=TRUE,
                    bugs.directory=bugspath
                      )
          result <- data.frame(output$sims.matrix)                        # tableau brut des resultats
          }
      
      if (vartype=="var_t")                           # variance en fonction de t
          {    
          data<-list(T=n,yield=x)
          vars2keep<-list("a","Y","tau.obs")
          inits<-function(){list(tau.state.a=0.1, tau.e=1,M=0, Phi=0.95)}

          output<-bugs(
                    model.file=file.path(modelpath),   
                    data=data,
                    inits = inits,
                    parameters.to.save =vars2keep,
                    n.chains=nchains,
                    n.iter=niter,
                    n.burnin=nburnin,
                    n.thin=nthin,
                    DIC=TRUE,
                    bugs.directory=bugspath
                      )
          result <- data.frame(output$sims.matrix)                    
          }          
    }                # fin modele sans pente
                                                                          
    # 2) Modele avec pente
    
    if (modeltype==1)
      {
      if (vartype=="var_cste")             #variance constante
          {
          data<-list(T=n,yield=x)
          vars2keep<-list("a","Y","tau.obs","b")
          inits<-function(){list(tau.state.a=0.1, tau.state.b=0.1, tau.obs=0.1)}

          output<-bugs(
                    model.file=file.path(modelpath),
                    data=data,
                    inits = inits,
                    parameters.to.save =vars2keep,
                    n.chains=nchains,
                    n.iter=niter,
                    n.burnin=nburnin,
                    n.thin=nthin,
                    DIC=TRUE,
                    bugs.directory=bugspath
                      )
          result <- data.frame(output$sims.matrix)
          
      tab_pente_i <- data.frame("Group"=tab_i$Group,"Time"=tab_i$Time)
      tab_pente_i["pente"] <- apply(result[,(2*DifYear+2):(3*DifYear+1)],2,mean) 
      tab_pente <- rbind(tab_pente,tab_pente_i)    
          
          
          }
          
      if (vartype=="var_t")               #variance en fonction de t
          {             
           data<-list(T=n,yield=x)
          vars2keep<-list("a","Y","tau.obs")
          inits<-function(){list(tau.state.a=0.1, tau.state.b=0.1,  tau.e=1,M=0, Phi=0.95)}

          output<-bugs(
                    model.file=file.path(modelpath),
                    data=data,
                    inits = inits,
                    parameters.to.save =vars2keep,
                    n.chains=nchains,
                    n.iter=niter,
                    n.burnin=nburnin,
                    n.thin=nthin,
                    DIC=TRUE,
                    bugs.directory=bugspath
                      )
          result <- data.frame(output$sims.matrix)
          
           
           
          
          }
          

    }       # fin modele avec pente     
           
# tableau de rsultats
                  
tab_calcul_i <- data.frame("Group"=tab_i$Group,"Time"=tab_i$Time)
       tab_calcul_i["Y"] <- apply(result[,1:DifYear],2,mean)                     # moyenne de la distribution de rendement
       tab_calcul_i["Y_1"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.01)      # percentiles totaux
       tab_calcul_i["Y_2.5"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.025) 
       tab_calcul_i["Y_5"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.05)           
       tab_calcul_i["Y_10"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.1)  
       tab_calcul_i["Y_25"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.25) 
       tab_calcul_i["Y_75"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.75)     
       tab_calcul_i["Y_90"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.9)  
       tab_calcul_i["Y_95"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.95)      
       tab_calcul_i["Y_97.5"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.975)  
       tab_calcul_i["Y_99"] <- apply(result[,(DifYear+1):(2*DifYear)],2,quantile,probs=0.99)      
       tab_calcul_i["y_1"] <- apply(result[,1:DifYear],2,quantile,probs=0.01)      # percentiles tendance
       tab_calcul_i["y_2.5"] <- apply(result[,1:DifYear],2,quantile,probs=0.025)
       tab_calcul_i["y_5"] <- apply(result[,1:DifYear],2,quantile,probs=0.05)      
       tab_calcul_i["y_10"] <- apply(result[,1:DifYear],2,quantile,probs=0.1)    
       tab_calcul_i["y_25"] <- apply(result[,1:DifYear],2,quantile,probs=0.25)    
       tab_calcul_i["y_75"] <- apply(result[,1:DifYear],2,quantile,probs=0.75)    
       tab_calcul_i["y_90"] <- apply(result[,1:DifYear],2,quantile,probs=0.9)    
       tab_calcul_i["y_95"] <- apply(result[,1:DifYear],2,quantile,probs=0.95)    
       tab_calcul_i["y_97.5"] <- apply(result[,1:DifYear],2,quantile,probs=0.975)
       tab_calcul_i["y_99"] <- apply(result[,1:DifYear],2,quantile,probs=0.99) 
       tab_calcul_i["sd_tot"] <- apply(result[,(DifYear+1):(2*DifYear)],2,sd)     #  ecart type total (tendance+interannuelle)
       tab_calcul_i["sd_trend"] <- apply(result[,1:DifYear],2,sd)     #   ecart type tendance
       if (vartype=="var_t")                                         
       {
       tab_calcul_i["sd_res"] <- sqrt(apply(1/result[,(2*DifYear+1):(3*DifYear)],2,mean))     # variance inter annuelle  (si variance variable)
       } else {
       tab_calcul_i["sd_res"] <- sqrt(rep(mean(1/result$tau.obs),DifYear))                    # variance inter annuelle (si variance constante)
       }
             
      tab_calcul <- rbind(tab_calcul,tab_calcul_i)
      
                   #RMSE  / DIC
        RMSEtab<- subset(tab_calcul,tab_calcul$Time<=maxYear_i)
      RMSE <- sqrt(mean((na.omit(tab_i$Y)-na.omit(RMSEtab$Y))^2))
      tab_dic_i=data.frame("Group"=tab_i$Group[1],"RMSE"=RMSE,"DIC"=output$DIC)
      tab_dic=rbind(tab_dic,tab_dic_i)
                


   }                      # fin de la boucle par entite geographique   
   
      if ( save_obs!=F)
   {write.table(tab_obs,save_obs) }
   if (save_calcul!=F)
   {write.table(tab_calcul,save_calcul)}     
   
   result<- list()
   result[[1]]<-tab_obs
   result[[2]]<-tab_calcul
   result[[3]]<-tab_dic
        if (modeltype==1)
        {   result[[4]]<-tab_pente
           names(result)=c("observation","prediction","dic_rmse","pente") 
         } else {
        
   names(result)=c("observation","prediction","dic_rmse")   }
   return(result)
      
}                       # fin de la fonction
