# RMT Modlisation & Analyse de Donnes - Atelier Srie temporelle 10 juillet 2014
# Juliette Adrian (INRA)
###################################################
#  Linear model (linear,quadratic,cubic)          #
###################################################


linear_model <- function ( type,year, datas,save_tab=F)
{
tab_tot <- read.table(datas,h=T)            # appel du tableau de donnees
predict=data.frame()                        # creation du tableau de sortie
tab_aic=data.frame()

for ( i in 1:length(levels(tab_tot$Group)))       # boucle par region
  {
   tab=subset(tab_tot,tab_tot$Group==levels(tab_tot$Group)[i])          # extraction du tableau concernant la region

   
   T=seq(min(tab$Time),max(tab$Time))
   T <- c(T,seq(max(T)+1,year))                                    # annees  estimer + predire
   
    Y <-tab$Y
    Y <- c(Y,rep(NA,(year-max(tab$Time))))                                                               # rendement observs + NA  prdire

     if ((max(tab$Time)-min(tab$Time)+1)!=length(tab$Time))
     { print(paste(levels(tab_tot$Group)[i],"missing datas")) 
     next}


   if (type==1)      # modele lineaire
   {
    model=lm(Y~T)
   }

   if (type==2)      # modele quadratique
   {
    model=lm(Y~T+I(T^2))
   }

   if (type==3)     # modele cubique
   {
    model=lm(Y~T+I(T^2)+I(T^3))
   }

   AIC=AIC(model)                        # print AIC par region
     tab_aic_i=data.frame("Group"=levels(tab_tot$Group)[i],"AIC"=AIC)     
      tab_aic=rbind(tab_aic,tab_aic_i)
    
   
   new=data.frame(x=seq(min(T),year))             # nouveau vecteur pour prdiction
   
   predict_conf1=predict.lm(model,new,interval="confidence",se.fit=T,level=0.98)      # variation sur la tendance
   predict_conf2=predict.lm(model,new,interval="confidence",se.fit=T,level=0.95)
   predict_conf3=predict.lm(model,new,interval="confidence",se.fit=T,level=0.9)
   predict_conf4=predict.lm(model,new,interval="confidence",se.fit=T,level=0.8)
   predict_conf5=predict.lm(model,new,interval="confidence",se.fit=T,level=0.5)
   predict_pred1=predict.lm(model,new,interval="prediction",se.fit=T,level=0.98)       # variation totale
   predict_pred2=predict.lm(model,new,interval="prediction",se.fit=T,level=0.95)
   predict_pred3=predict.lm(model,new,interval="prediction",se.fit=T,level=0.9)
   predict_pred4=predict.lm(model,new,interval="prediction",se.fit=T,level=0.8)
   predict_pred5=predict.lm(model,new,interval="prediction",se.fit=T,level=0.5)

   predict_i=data.frame("Group"=rep(levels(tab_tot$Group)[i],length(new$x)),"Time"=new$x)      # tableau de sortie par region
  

   if (length(tab$Code)!=0)
   { predict_i[,"Code"]=rep(tab$Code[1],length(new$x)) }
      
   predict_i$Y=predict_conf1[[1]][,1]                       # moyenne
   predict_i$Y_1=predict_pred1[[1]][,2]                     # percentiles totaux
   predict_i$Y_2.5=predict_pred2[[1]][,2]
   predict_i$Y_5=predict_pred3[[1]][,2]
   predict_i$Y_10=predict_pred4[[1]][,2]
   predict_i$Y_25=predict_pred5[[1]][,2]
   predict_i$Y_75=predict_pred5[[1]][,3]
   predict_i$Y_90=predict_pred4[[1]][,3]
   predict_i$Y_95=predict_pred3[[1]][,3]
   predict_i$Y_97.5=predict_pred2[[1]][,3]
   predict_i$Y_99=predict_pred1[[1]][,3]
   predict_i$y_1=predict_conf1[[1]][,2]                        # percentiles tendance
   predict_i$y_2.5=predict_conf2[[1]][,2]
   predict_i$y_5=predict_conf3[[1]][,2]
   predict_i$y_10=predict_conf4[[1]][,2]
   predict_i$y_25=predict_conf5[[1]][,2]
   predict_i$y_75=predict_conf5[[1]][,3]
   predict_i$y_90=predict_conf4[[1]][,3]
   predict_i$y_95=predict_conf3[[1]][,3]
   predict_i$y_97.5=predict_conf2[[1]][,3]
   predict_i$y_99=predict_conf1[[1]][,3]
   predict_i$sd_tot=predict_conf1$se.fit+rep(summary(model)[[6]],length(new$x)) 
   predict_i$sd_trend=predict_conf1$se.fit                          #ecart type tendance
   predict_i$sd_res=rep(summary(model)[[6]],length(new$x))

   predict=rbind(predict,predict_i) 
   # rbind tableaux par region
  
  }

if (save_tab!=F)
{write.table(predict,save_tab) }                          # sauvegarde du tableau de sortie

result<-list()
result[[1]]<-predict
result[[2]]<-tab_aic 
names(result)=c("prediction","aic") 
return(result)

}                                                       # fin de la fonction

##############################################################################################################################