# RMT Modlisation & Analyse de Donnes - Atelier Srie temporelle 10 juillet 2014
# Juliette Adrian (INRA)
###########################################
####  CARTES : ESTIMATION / PREDICTION ####
###########################################

carte <- function (variable,year,maptype,datas,colour)

{

library(RColorBrewer)
library(classInt)
library(maptools)

tab=read.table(datas,h=T)
tab$Code <- as.factor(as.character(tab$Code) )

tab_map <-data.frame("Code"=levels(tab$Code),"variable"=NA,"classe"=NA)


# I/ CREATION DES TABLEAUX

       for(i in 1:length(levels(tab$Code)) )                         # debut boucle pour chaque entit gographique
  {
    tab_i=subset(tab,tab$Code==levels(tab$Code)[i])
    tab_i=data.frame("Code"=tab_i$Code,"Group"=tab_i$Group,"Time"=tab_i$Time,variable=tab_i[variable])

    if (all(is.na(tab_i[variable])))
     { next }                                                       
  
    maxYear_i=max(na.omit(tab_i)["Time"])

   tab_map[i,"variable"] <- max(subset(tab_i[variable],tab_i$Time==year))
    title=variable

  }      # fin boucle for par entit

# II/ CLASSES

nclasses=5
classe <- classIntervals(na.omit(tab_map$variable), nclasses, style="quantile")

tab_map$classe <- cut(tab_map$variable,breaks=c(classe$brks[1]-0.01,classe$brks[2],classe$brks[3],classe$brks[4],classe$brks[5],classe$brks[6]+0.01),labels=F)  

for (i in 1:length(tab_map$classe))         #ajout d'une classse pour na
{ if (all(is.na(tab_map[i,"classe"])))
{tab_map[i,"classe"] <-nclasses+1}
} 



#if (variable=="slope")
#{
   
#   classe_min<- min(classe$brks[classe$brks>=0])       # borne  0 pour les classes des pentes
               
#   if (classe_min == classe$brks[2])
#        { classe$brks[2] = 0 }
        
#   if (classe_min == classe$brks[3])
#        { classe$brks[3] = 0 }
        
#   if (classe_min == classe$brks[4])
#        { classe$brks[4] = 0 }        

#   if (classe_min == classe$brks[5])
#        { classe$brks[5] = 0 }
#}

legende = c(paste("[",round(classe$brks[1],3), "_", round(classe$brks[2],3)),paste("[",round(classe$brks[2],3),
"_", round(classe$brks[3],3)), paste("[",round(classe$brks[3],3), "_", round(classe$brks[4],3)), paste("[",round(classe$brks[4],3), 
"_", round(classe$brks[5],3)), paste(">", round(classe$brks[5],3)), paste ("pas de donnes"))

# III/ CARTE

color <- brewer.pal(nclasses,colour)  #gamme de couleur pour carte
color <- c(color,"grey")    #ajout de la couleur pour les na


if (maptype=="world")
{
map <- readShapeSpatial("CNTRY94.SHP")
map <- map[map$NAME !="Antarctica",]                   #chargement carte monde    
asso <- match(map$FIPS_CODE, tab_map$Code)          #association Code et code carte
limx=c(-170,200)
limy=c(-40,50)        
text1=c(-180,-65)
text2=c(-150,20)
text3=c(0,-80)
}

if (maptype=="region")
{
map <- readShapeSpatial("Rgions_region.shp")   #chargement carte region
asso <- match(map$RgION, tab_map$Code) 
limx= c(290000,1000000)
limy= c(1500000,2800000)
text1=c(6000, 1600000)
text2=c(100000,2250000)
text3=c(543015,2750000)
}

if (maptype=="departement")
{
map <- readShapeSpatial("DEPARTEMENT.shp")
asso <- match(map$ID_GEOFLA, tab_map$Code)
limx=c(0,5)
limy=c(40, 52)
text1=c(-5, 42)
text2=c(-1,51)
text3=c(2,52.2)
}

x11()

plot (map, col=color[tab_map$classe[asso]],xlim=limx,ylim=limy)         #map
leg.txt <- legende
legend(text1[1],text1[2],leg.txt,col=color,pch=15,bty="n",cex=0.6, horiz=TRUE)
text(text2[1],text2[2], year, pos=1,cex=1.8, font=2, col="black")
text(text3[1],text3[2], title, pos=1,cex=0.8, font=2, col="black")


}   #fin de la fonction