# comparaison de 2 moyennes
t.test(LOX~inocule, statenz, var.equal=TRUE)

# comparaison de 2 variances
var.test(LOX~inocule, statenz)

# corrlation
cor(statenz$PO, statenz$jours)
cor.test(~PO+jours,statenz)

# tableau crois : 1 variable quali * 1 variable quanti
with(statenz, tapply(GST,cultivar, mean))

# tableau crois : 2 variables quali * 1 variable quanti
with(statenz, tapply(GST,list(cultivar, inocule), mean))

# tableau crois : 2 variables quali, et test du chi2
temp<- data.frame(
	V1=sample(letters[1:5],300, replace=T),
	V2=sample(LETTERS[1:5],300, replace=T))
table(temp$V1, temp$V2)
chisq.test(table(temp))

# test de normalit
W <- statenz$GST
shapiro.test(W)

# rgression linaire simple
setwd("C:/R_ITA/")
weather <- read.table("data/meteo.dat", h = TRUE, dec = ',')
head(weather)
Fit<- lm(weather$tmax~weather$radiation)
print(Fit)
summary(Fit)
COEF <- Fit$coefficients
plot(weather$radiation,weather$tmax, xlab="radiation", ylab="Tmax")
abline(a=COEF[1], b=COEF[2],lty=2)

# analyse de la variance
toto <- statenz[statenz$cultivar=="v1" &
		statenz$inocule=="i",]
toto$series <- as.factor(toto$series)
res_lm <- lm(PO~jours + series, toto)
anova(res_lm)
summary(res_lm)$sigma	# ETR



