library(MASS)
library(spatial)
setwd("D:/R_ITA/")

sites <- read.table('data/sites.dat', sep =' ', h = T);

WeatherSum <- read.table('data/WeatherSum.dat', sep =' ', h = T);

WeatherSumYear <- subset(WeatherSum, years==2000)

sites_WeatherSumYear = merge(sites, WeatherSumYear,by.x='id',by.y='site')


sites_WeatherSumYear_Ex = sites_WeatherSumYear[,c("GPSlongitudes","GPSlatitude", "SumTemp")]

names(sites_WeatherSumYear_Ex)=c("x","y","z")

#sites_WeatherSumYear_Ex=sites_WeatherSumYear_Ex[1:10,]
                  
sites_WeatherSumYear_Ex.kr <- surf.ls(2, sites_WeatherSumYear_Ex)

variogram(sites_WeatherSumYear_Ex.kr, 250)

# Creating data frame with cardinal limits
limits <- data.frame(limits = c('NO', 'NE', 'SO', 'SE'), Lat = rep(NA, 4), Long = rep(NA, 4));
# Latitudes and longitudes vectors as defined earlier

lat <- c(49.115278, 49.115278, 43.3017, 43.3017);
long <- c(-1.090278, 1.443962, -1.090278, 1.443962);
limits$Lat <- lat;
limits$Long <- long;

trsurf <- trmat(sites_WeatherSumYear_Ex.kr,  long[1], long[2],lat[3], lat[1], 100)

eqscplot(trsurf, type = "n")
contour(trsurf, add = TRUE)


library(maps);

map(database="france", fill=FALSE, mar=c(0,0,0,0))
#points(limits$Long, limits$Lat, pch = 20, col = 'red');
rect(limits$Long[1], limits$Lat[3], limits$Long[2], limits$Lat[1],  border = rgb(0,0,0,0.2));

points(sites_WeatherSumYear_Ex$x,sites_WeatherSumYear_Ex$y , col="red",cex=0.5,pch=10)

#contour(trsurf, add = TRUE)


#filled.contour(trsurf, color = terrain.colors, asp = 1, levels=pretty(c(min(trsurf$z),max(trsurf$z)), 20))
