# UMR AGIR - Ateliers R - representation graphique
# Sylvain Toulet (INRA), Franois Brun (ACTA), Pierre Casadebaig (INRA)
# 9 mai 2012

# TODO : chemin du rep de travail.
setwd("D:/R_ITA/")
# Nuage de points
# On charge le fichier de donnees
data <- read.table("data/nuagedepointsdata.dat", h = TRUE);

# Premiere etape : tracer le nuage de points de Dim2 en fonction de Dim1
plot(data$Dim1, data$Dim2, pch = 16, xlim = c(-1.5, 1.5), ylim = c(-2, 2), xlab = 'Dim1', ylab = 'Dim2');
# Ajout des axes passant par 0
abline(h = 0, v = 0, lty = 2);
# Ajout des etiquettes de nom pour chaque point
text(data$Dim1, data$Dim2, data$Name, cex = 0.7, pos = 4);

################################################################################
# 2 axes
# On charge le fichier de données
data <- read.table("data/meteo.dat", h = TRUE, dec = ',');
# On augmente la taille des marges de part et d'autre du graphe (dans l'ordre : bas, gauche, haut, droite)
dev.new()
par(mar = c(3, 5, 2, 5));
# On trace le diagramme baton des precipitations et on stocke dans X les coordonnees d'abscisses correspondant au milieu de chaque barre
X <- barplot(data$rainfall, width=0.8, beside = F, yaxt='n', ylim = c(0, 140), ylab ='Rainfall (mm)');
# creation d'un vecteur contenant les points a graduer sur les axes y
loc <- c(0, 20, 40, 60, 80, 100, 120, 140);
# on trace le premier axe a gauche correspondant a la pluviometrie
axis(2, at = loc, las = 2);
# On trace les températures correspondant aux differentes valeurs de pluviometrie. Attention, bien noter que les valeurs de températures ont ete multipliees par 4 pour aerer le graphe.
lines((data$tmin)*4~X, col = 'blue');
lines((data$tmax)*4~X, col ='red');
# on trace l'axe a droite pour les temperatures, les labels sont places au meme niveau que pour l'axe de gauche, mais l'échelle n'est pas la meme (facteur 4)
axis(4, at = loc, labels = loc/4, las = 2);
# Ajout de la legende de l'axe de droite. srt = 90 nous permet de placer le texte parallèle à l'axe.
mtext("Temperature (°C)", side = 4, line = 3, srt = 90);