library(ggplot2)

# manuel ggplot2 : http://had.co.nz/ggplot2/
# aide simple : http://wiki.stdout.org/rcookbook/Graphs/

########################################################################
## Construction du jeu de données
temperature <- function (x, o=25, w=0.008) {pmax(1 - (w * (x - o)^2),0)}
receptivity <- function (x, t=500) {1 / (1 + exp(-0.005 * (x - t))) + 0.2}

x.t <- seq(0,40, by=0.5)
x.r <- seq(0,1500, by=10)

d <- data.frame(
	variable = rep(c("temperature","receptivity"), time=c(length(x.t), length(x.r))),
	x = c(x.t, x.r),
	y = c(temperature(x.t), receptivity(x.r)),
	label = c(paste("t",1:length(x.t), sep=""), paste("r",1:length(x.r), sep=""))
)

str(d)
	
## Exemples de visualisation
# Univarié

ggplot(subset(d, variable=="temperature"), aes(y)) + geom_histogram(binwidth=0.5)
ggplot(d[d$variable=="temperature",], aes(x=variable, y=x)) + geom_boxplot()

# Bivarié
ggplot(d[d$variable=="temperature",], aes(x,y)) + geom_bar(stat='identity')
ggplot(d[d$variable=="temperature",], aes(x,y)) + geom_point()
ggplot(d[d$variable=="temperature",], aes(x,y, label=label)) + geom_text(size=3) + geom_point()
ggplot(d[d$variable=="temperature",], aes(x,y)) + geom_area()
ggplot(d[d$variable=="temperature",], aes(x,y)) + geom_area() + annotate("text",x=0,y=1,label="a")

# Bivarié + conditionnement
ggplot(d, aes(x, y)) + geom_point() 

g <- ggplot(d, aes(x, y)) 

g + geom_line() + facet_wrap(~ variable) 
	
g + geom_line() + facet_wrap(~ variable, scales="free_x")

g + geom_line() +
	facet_wrap(~ variable, scales="free_x", ncol=2) +
	xlab("") + ylab("Process response") + theme_bw() +
	opts(aspect.ratio = 1)

# Ecriture
Cairo(file="response.pdf", width = 8, height = 5, units="in", type="pdf", pointsize=10) 
print(response)
dev.off()

########################################################################
## Notes

