################################################################################
# Course SMACH - January 2014
# project - Script to read weather data for climate change projection
# version $Date:: 2014-04-30 1#$ by $Author: brun $(v0: 2013-10-9)
################################################################################
setwd("D:/CourseSmach/")
source("rscript/projects/CimateChange_correction/zadoks.simpleweather.model.r")
load("data/weather/DRIAS/SCRATCH08_arpege_v4_retic.rda")
weather_drias=SCRATCH08_arpege_v4_retic
# first lines of data.frame
head(weather_drias)
# structure of data.frame
str(weather_drias)
# table of scenarios and periods
unique(weather_drias[,c("scenario","period")])
attr(weather_drias, "nom_variable")
unique(weather_drias[,c("idPoint",  "Latitude","Longitude")])
nom_site=c("4063"="INRA Auzeville (near Toulouse)", "14650"="INRA_Grignon (near Paris)",  "8531"="Arvalis Satolas (near Lyon)")
# conversion precipitation kg/m2/s => mm/day
weather_drias$rain= weather_drias$prr * (60*60*24)
# conversion Kelvin en degC K - 273,15
weather_drias$TMIN = weather_drias$tasmin - 273.15
weather_drias$TMAX = weather_drias$tasmax - 273.15
weather_drias$TMEAN = weather_drias$tas - 273.15
################################################################################
# representation of weather tendancy
weather_drias$scenario_period_site= paste(weather_drias$scenario , weather_drias$period, weather_drias$idPoint, sep="_")
res = lapply(unique(weather_drias$scenario_period_site), function(sps) {
data.frame(sps=sps,mean_T=mean(weather_drias[weather_drias$scenario_period_site==sps,"tas"]),mean_Rain=mean(weather_drias[weather_drias$scenario_period_site==sps,"rain"]), stringsAsFactors=FALSE)
})
res=do.call(rbind, res)
sps=do.call(rbind,strsplit(res$sps, "_"))
colnames(sps)=c("scenario", "period", "site")
res=cbind(sps, res[,-1])

################################################################################
SITE0= 10^30
sdate=1
ldate=150

# 1) definition of the numerical design. Unit of Simulation of Model (USM)
table_usm = unique(weather_drias[,c("idPoint", "scenario", "year", "period")])

# 2) run the model for each USM and keep a synthetic variable (AUDPC)
sim_all= data.frame()
#for (usm in 1:100 ){ 
for (usm in 1:nrow(table_usm)){
print(usm)
idPoint=table_usm[usm,"idPoint"]
scenario=table_usm[usm,"scenario"]
year=table_usm[usm,"year"]
period=table_usm[usm,"period"]

#print(year)
weather=weather_drias[(weather_drias$idPoint==idPoint)&(weather_drias$scenario==scenario)&(weather_drias$year==year)&(weather_drias$period==period),c("year","day","TMEAN","TMIN","TMAX","rain") ]
names(weather)= c("year","day","TMEAN","TMIN","TMAX","RAIN")         

#print(head(weather))

out = zakoks.simpleweather.model(nlpd_T=80,nipd_T=200,dmfr=16,SITE0 = SITE0, weather, sdate = sdate, ldate = ldate )

#print(head(out$sim))
AUDPC=sum(out$sim$severity)

sim_all=rbind(sim_all, data.frame(idPoint=idPoint, scenario=scenario, year=year, period=period,AUDPC=AUDPC, stringsAsFactors =FALSE))
}
# 3) representation of results
par(mfrow=c(3,1))
summaryTable=data.frame()
for (idPoint in unique(sim_all$idPoint)){
sim_all_pt=sim_all[sim_all$idPoint==idPoint,]    
grpdata=split(sim_all_pt$AUDPC, paste (sim_all_pt$period, sim_all_pt$scenario)  )
grpdata=grpdata[unique(paste(sim_all_pt$period, sim_all_pt$scenario))]
boxplot(grpdata, main=nom_site[as.character(idPoint)])

summaryTable=rbind(summaryTable, cbind(idPoint, site=nom_site[as.character(idPoint)],sp=names(grpdata),do.call(rbind,lapply(grpdata, summary))))
}
summaryTable

# comparaison of site for one scenario-period
summaryTable[summaryTable$sp=="Ref ref",]
# end of file