################################################################################
# Course SMACH - January 2014
# a classical SEIR model. From original publication of Zadoks (1971)
# without boxcar train
# with weather effect on latency and infectious period
# version $Date:: 2014-04-30 1#$ by $Author: brun $(v0: 2013-12-11)
################################################################################
zakoks.simpleweather.model = function (nlpd_T=40,nipd_T=200,dmfr=16,SITE0 = 5*10^9,weather, sdate = 1, ldate = 140){
    XVAC <- rep(NA, ldate)
    # Latent
    XLAT <- rep(NA, ldate)
    # Infectious
    XINF <- rep(NA, ldate)
    XCTR <- rep(NA, ldate)

    # initialization of state variable
    XVAC[sdate] <- SITE0-1
    XLAT[sdate] <- 1
    XINF[sdate] <- 0
    XCTR[sdate] <- 0

    for (day in sdate:(ldate - 1)) {
        #if (day==inf_start){BOXI[day,"XINF"]=1, BOXI[sdate,"sumTEEQ"] = 1}
        # correction factor : feed back from total occupied sites
        cofr<-max(XVAC[day]/SITE0, 0)
        # rocc: rate of occupation : nb of sites Vacant=>Latent
        rocc = min(cofr * dmfr * XINF[day], XVAC[day])

        TMEAN= max((weather$TMIN[day]+weather$TMAX[day])/2, 0)
        # rapp: rate of apparition : nb of sites Latent=>Infectant
        rapp= min(XLAT[day] * TMEAN/nlpd_T, XLAT[day]+rocc)

        # rrem: rate of removal : nb of sites Infectant=>removed
        rrem=min(XINF[day] * TMEAN/nipd_T, XINF[day]+rapp)


        XVAC[day+1] <- XVAC[day]-rocc
        XLAT[day+1] <-XLAT[day] +rocc - rapp
        XINF[day+1] <- XINF[day] + rapp - rrem
        XCTR[day+1] <- XCTR[day] + rrem
    }
    
    XTO1 = XLAT+XINF+XCTR
    XSEV = XINF+XCTR
    severity=XSEV/(XLAT+XINF+XCTR+XVAC)
    return(list(sim=data.frame(day = sdate:ldate, XVAC = XVAC[sdate:ldate], XLAT = XLAT[sdate:ldate], XINF = XINF[sdate:ldate],XCTR = XCTR[sdate:ldate],XTO1=XTO1[sdate:ldate],  XSEV= XSEV[sdate:ldate], severity=severity[sdate:ldate]), param=c(nlpd_T=nlpd_T,nipd_T=nipd_T,dmfr=dmfr,SITE0 = SITE0)))
}

################################################################################
################################################################################
# end of file