################################################################################
# "Working with dynamic models for agriculture"
# R script for pratical work
# Daniel Wallach (INRA), David Makowski (INRA), James W. Jones (U.of Florida),
# Francois Brun (ACTA)
# version : 2010-08-09
# Model described in the book, Appendix. Models used as illustrative examples: description and R code
############################## MAIN PROGRAM ####################################
library(ZeBook)
# define the working directory in which maize.exe is
setwd("C:/ZeBook/R_intro")
# define and save the one year weather in file weather.dat
write.table(maize.weather(working.year=2010, working.site=1),file="weather.dat",sep=";",col.names=T,row.names=F,quote=F,dec="." )
# define and change the parameter value
param <- maize.define.param()["nominal",]
param.table <- rbind(data.frame(param=names(param),value=param,stringsAsFactors=F), c("sdate",100),c("ldate",250))
write.table(param.table,file="param.ini",sep=";",col.names=T,row.names=F,quote=F,dec="." )
# run the executable maize.exe from R
shell("maize.exe")
# fetch results in the file result.dat
result <- read.table(file="result.dat",sep=";",header=T,dec="." )
head(result)

# verification of result
result2 <- maize.model(param["Tbase"],param["RUE"],param["K"],param["alpha"],param["LAImax"],param["TTM"],param["TTL"],maize.weather(working.year=2010, working.site=1),100,250)

all(result==result2)