library(reshape2)
library(maps)

rpg = read.csv("data/RPG/RPG2016_select.csv", sep=";", header=T, stringsAsFactors = F)

rescoord = colsplit(rpg$Geo.Point, ", ", c("lat","lon"))
rpg$latitude = rescoord[,"lat"]
rpg$longitude = rescoord[,"lon"]

par(mar=c(0,0,0,0))
map(regions="France")
points(rpg$longitude,rpg$latitude, col="red")
