################################################################################
# Atelier Atelier Caractrisation de l'tat des cultures (satellite et proxidtection) 
# et mthodes d'assimilation de donnes dans les modles
# 21 juin 2018
# filtre de Kalman : sur valeur moyenne de la parcelle et variance moyenne sur la saison
# Francois Brun (ACTA)
# version : 2018-06-20
############################### MAIN PROGRAM ###################################
library(ZeBook)
library(dlm)
source("maize.lai.model.r")


# chargement des donnees
load(file="data/LAI_CSV_Toulouse_43.6895_1.2877_2017_all.rda")
head(df_all)
load(file="data/LAI_CSV_Toulouse_43.6895_1.2877_2017_summary.rda")
df_summary
df_summary$day=as.numeric(format(df_summary$date,format="%j"))
df_summary$LAIobs=df_summary$lai_mean

load(file="data/weather_specSites.rda")
head(weather_specSites)
weather_specSites$idsite=weather_specSites$site

# choose a year and a site
year=2017
idsite="Blagnac"
weather = maize.weather(working.year=year,working.site=idsite,weather_all=weather_specSites)


Tbase=7; RUE=1.85; K=0.7; alpha=0.0020; LAImax=5; TTM=1200; TTL=900;
# date semis : 20 avril => sdate = 110
sdate=110; ldate=270

sim = maize.LAI.model(Tbase, RUE, K, alpha, LAImax, TTM, TTL, weather, sdate,ldate)  

# build a table with ALL simulation and observation
simobs = merge(sim, df_summary, all.x = TRUE)[,c("day","LAIobs","lai_sd","TT","LAI","B")]
simobs
plot(simobs$day,simobs$LAI,type="l")
points(simobs$day,simobs$LAIobs)




#TAB=watbal.simobsdata

#x : simulation for each day
x<-matrix(simobs$LAI,ncol=1)

#variance empirique
# moyenne des variances sur l'ensemble des jours
Vemp<-mean((simobs$lai_sd[!is.na(simobs$lai_sd)])^2)


buildFun<-function(theta) {
  modWAT<-dlmModReg(x,dV=Vemp,dW=c(exp(theta[1]),exp(theta[2])))
  return(modWAT)
}

# Y : observation
Y<-simobs$LAIobs

# Parameter estimation
fit<-dlmMLE(Y,parm=c(0,0),build=buildFun)
fit

#
fitted.mod<-buildFun(fit$par)

# filtrage
modFilter<-dlmFilter(Y,mod=fitted.mod)
modFilter$m

# lissage (prise en compte de toute les donnes)
modSmooth<-dlmSmooth(Y,mod=fitted.mod)
SmoothedLAI<-modSmooth$s[,1][-1]+modSmooth$s[,2][-1]*x
SmoothedLAI[SmoothedLAI<0]<-0

# graphical representation
plot(1:length(x),Y,ylim=c(0,5.5),pch=19, xlab="Time (days)", ylab="LAI")
lines(1:length(x),x,lty=2)
lines(1:length(x),(modFilter$m[-1,1]+modFilter$m[-1,2]*x))
lines(1:length(x),SmoothedLAI, lty=3, lwd=1, col="blue")
legend("topleft",legend = c("obs","wo corr", "with corr", "lissage"), lty=c(0,2,1,3),
       pch=c(19,NA,NA,NA), col=c("black","black","black","blue"))

# end of file