################################################################################
library(ZeBook)
source("maize.lai.model.r")

# chargement des données
load(file="data/LAI_CSV_Toulouse_43.6895_1.2877_2017_all.rda")
head(df_all)
load(file="data/LAI_CSV_Toulouse_43.6895_1.2877_2017_summary.rda")
df_summary
df_summary$day=as.numeric(format(df_summary$date,format="%j"))
df_summary$LAIobs=df_summary$lai_mean
df_summary=as.data.frame(df_summary)

load(file="data/weather_specSites.rda")
head(weather_specSites)
weather_specSites$idsite=weather_specSites$site

# choose a year and a site
year=2017
idsite="Blagnac"
weather = maize.weather(working.year=year,working.site=idsite,weather_all=weather_specSites)
weather[weather$I==-99,"I"]=mean(weather[weather$I!=-99,"I"])

####################################################################
# sans correction
Tbase=7; RUE=1.85; K=0.7; alpha=0.0020; LAImax=5; TTM=1200; TTL=900;
# date semis : 20 avril => sdate = 110
sdate=110; ldate=270
TT <- rep(NA, ldate)
B <- rep(NA, ldate)
LAI <- rep(NA, ldate)
TT[sdate] <- 0
B[sdate] <- 1
LAI[sdate] <- 0.01
for (day in sdate:(ldate - 1)) {
  
  res = maize.LAI.update(TT0=TT[day], B0=B[day],LAI0=LAI[day], Tmin=weather$Tmin[day], Tmax=weather$Tmax[day], I=weather$I[day],  Tbase, RUE, K, alpha, LAImax, TTM, TTL) 
  
  TT[day + 1] <- res$TT1
  B[day + 1] <- res$B1
  LAI[day + 1] <- res$LAI1
}
wo_correction = data.frame(days=sdate:ldate,TT=TT[sdate:ldate], B=B[sdate:ldate],
                           LAI=LAI[sdate:ldate])
plot(LAI~days, data=wo_correction,type="l")
plot(B~days, data=wo_correction,type="l")

####################################################################


# data sentinnelle
dataobs = df_summary
# we considere error of mesurement is normal with a variance sigma^2
sigma.LAIobs = mean((df_summary$lai_sd[!is.na(df_summary$lai_sd)])^2)

################################################################################
## data assimilation
## Filtre particulaire
#' @title Fonction Filtre particulaire
#' @export
#' @arg x_prop : distribution des sortie du modle (a priori)
#' @arg measure :  Mesure disponible
#' @arg Vm : variance des measures
FiltrePart<-function(x_prop, measure, Vm) {
# weight of prob(x knowing measure)
# Comment : if number of measure > 1, then it take in turn each value of measure to compute dnorm(one_single_measure,mean=x_prop_number_k, sd=sqrt(Vm))
# TODO Need to check if Vm change with measure
w_x<-dnorm(measure,mean=x_prop, sd=sqrt(Vm))
w_x<-w_x/(sum(w_x))
# We resample in prior x_prop according to weight (likelihood)
x_new<-sample(x_prop,size=length(x_prop),prob=w_x,replace=TRUE)
return(x_new)
}


##Application du filtre particulaire
# graine pour rptabilit
set.seed(1)
N<-1000  #20000

# parametre de stockasticit du modele - defini en relatif 
# un bruit (arbitraire...)
erreur_relativeLAI ~ rnorm(u = 1, sd =sd_e)
sd_e = 80/100

#Initialisation
TT_mat <- matrix(nrow=N,ncol=ldate)
B_mat <- matrix(nrow=N,ncol=ldate)
LAI_mat <- matrix(nrow=N,ncol=ldate)

TT_mat[,sdate] <- 0
B_mat[,sdate] <- 1
LAI_mat[,sdate] <- 0.1

#x_mat<-matrix(nrow=N,ncol=ldate)
#x_mat[,1]<-pmax(rnorm(N,E_Y0,sqrt(V_Y0)),0)

for (day in sdate:(ldate - 1)) {
  
  for (k in 1:N){
    res = maize.LAI.update(TT0=TT_mat[k,day], B0=B_mat[k,day],LAI0= LAI_mat[k,day], Tmin=weather$Tmin[day], Tmax=weather$Tmax[day], I=weather$I[day],  Tbase, RUE, K, alpha, LAImax, TTM, TTL) 
    TT_mat[k,day + 1] <- res$TT1
    B_mat[k,day + 1] <- res$B1
    LAI_mat[k,day + 1] <- res$LAI1
  }
  erreur_relativeLAI = rnorm(N, 1, sd_e)
 # LAI_mat[,day+1]<-pmax(LAI_mat[,day + 1]*(1+erreur_relative), LAI_mat[,day])
  LAI_mat[,day+1]<-LAI_mat[,day] + (LAI_mat[,day+1]-LAI_mat[,day])*(erreur_relativeLAI)
  
  
  MesureDispo<-na.omit(dataobs[dataobs$day==day+1,"LAIobs"])
  if (length(MesureDispo)!=0) {
    print("assim donnees")
    V_m<-rep(sigma.LAIobs^2,length(MesureDispo))
    lai_n = 160 # 160 pixel pour estimer la moyenne
    V_m = dataobs[dataobs$day==day+1,"lai_sd"]^2/lai_n
    Result<-FiltrePart(LAI_mat[,day+1], MesureDispo, V_m)
    LAI_mat[,day+1]<-Result
  }
  
  
  
}


E_LAI<-apply(LAI_mat, 2, mean)
V_LAI<-apply(LAI_mat, 2, var)

q10_LAI<-apply(LAI_mat, 2, quantile, prob=0.10, na.rm=T)
q90_LAI<-apply(LAI_mat, 2, quantile, prob=0.90, na.rm=T)


plot(sdate:ldate, E_LAI[sdate:ldate], xlab="day", ylab="LAI",type="l",ylim=c(0,5),lty=4,lwd=2)
points(dataobs$day,dataobs$LAIobs, col="green", pch=16, cex = 1.5)
#lines(sdate:ldate, E_LAI[sdate:ldate],lwd=3)
lines(sdate:ldate, q10_LAI[sdate:ldate],lwd=2,lty=3, col="grey")
lines(sdate:ldate, q90_LAI[sdate:ldate],lwd=2,lty=3, col="grey")

lines(wo_correction$days,wo_correction$LAI, col="blue")

# End of file