############################################################################################################
maize.LAI.update = function (TT0, B0,LAI0, Tmin, Tmax, I,  Tbase, RUE, K, alpha, LAImax, TTM, TTL) 
{
  dTT <- max((Tmin + Tmax)/2 - 
               Tbase, 0)
  if (TT0 <= TTM) {
    dB <- RUE * (1 - exp(-K * LAI0)) * I
  }
  else {
    dB <- 0
  }
  if (TT0 <= TTL) {
    dLAI <- alpha * dTT * LAI0 * max(LAImax - LAI0,  0)
  }  else {
    if (TT0 <= TTL+200) {
      dLAI = 0
    } else {
      senec=0.0020
      dLAI <- - senec*dTT*(LAI0 - 0)
    }
  }
  TT1 <- TT0 + dTT
  B1 <- B0 + dB
  LAI1 <- LAI0 + dLAI
  
  return(list(TT1=TT1,B1=B1,LAI1=LAI1))
}
############################################################################################################
maize.LAI.model = function (Tbase, RUE, K, alpha, LAImax, TTM, TTL, weather, sdate,ldate) 
{
  TT <- rep(NA, ldate)
  B <- rep(NA, ldate)
  LAI <- rep(NA, ldate)
  TT[sdate] <- 0
  B[sdate] <- 1
  LAI[sdate] <- 0.01
  for (day in sdate:(ldate - 1)) {
    
    res = maize.LAI.update(TT0=TT[day], B0=B[day],LAI0=LAI[day], Tmin=weather$Tmin[day], Tmax=weather$Tmax[day], I=weather$I[day],  Tbase, RUE, K, alpha, LAImax, TTM, TTL) 
    
    TT[day + 1] <- res$TT1
    B[day + 1] <- res$B1
    LAI[day + 1] <- res$LAI1
  }
  return(data.frame(day = sdate:ldate, TT = TT[sdate:ldate], 
                    LAI = LAI[sdate:ldate], B = B[sdate:ldate]))
}
############################################################################################################
#library(ZeBook)
#weather = maize.weather(working.year=2010, working.site=30,weather_all=weather_EuropeEU)
#res2 = maize.LAI.model(Tbase=7, RUE=1.85, K=0.7, alpha=0.00243, LAImax=7, TTM=1200, TTL=700,
#            weather, sdate=100, ldate=250)

#res1 = maize.model(Tbase=7, RUE=1.85, K=0.7, alpha=0.00243, LAImax=7, TTM=1200, TTL=700,
#                       weather, sdate=100, ldate=250)
