################################################################################
# Atelier Atelier Caract?risation de l'?tat des cultures (satellite et proxid?tection) 
# et m?thodes d'assimilation de donn?es dans les mod?les
# 21 juin 2018
# filtre de Kalman : sur valeur moyenne de la parcelle et variance moyenne sur la saison
# Francois Brun (ACTA)
# version : 2018-06-20
############################### MAIN PROGRAM ###################################
library("tidyr")
library("dplyr")

listefichier = dir(path = "data/LAI_CSV_Toulouse_43.6895_1.2877_2017/", pattern = "SENTINEL")
#listefichier

df_all=data.frame()

for( fichier in listefichier){
ddate = substring(fichier,24,31)
df = unique(read.table(paste("data/LAI_CSV_Toulouse_43.6895_1.2877_2017/",fichier,sep=""), header=T))
df = cbind(ddate,df)
df_all=rbind(df_all, df)
}

df_all$date = as.Date(df_all$ddate, format="%Y%m%d")
# retirer les valeurs hors zone de LAI (trop petite ou trop grande)
#df_all = df_all[df_all$lai_flags!=0,]
dim(df_all)
head(df_all)
plot(df_all$Longitude ,df_all$Latitude)
#df_all[,c("date","ddate")]

hist(df_all$lai)
plot(df_all$date,df_all$lai)
boxplot(df_all$lai~df_all$date)

# données résumées
df_summary = df_all %>% group_by(date) %>%  summarize(lai_mean=mean(lai),lai_sd=sd(lai))

# sauvegarde des données
save(df_all,file="data/LAI_CSV_Toulouse_43.6895_1.2877_2017_all.rda")
save(df_summary,file="data/LAI_CSV_Toulouse_43.6895_1.2877_2017_summary.rda")