# Estimation of a causal effect of an agricultural practice based on observational data
# Korgan Aldebert (Acta), François Brun (Acta), David Makowski (Inrae), 2023-12-18
# Fertigation data : part 3. Standardisation


# Loading the fertigation data. The data present a bias in the amount of irrigation 
# depending on the implementation of fertigation (see part 1)
# the data are simulated, thus we know the "true" effects 
# intercept: 72.94 coeff_Drip : 8.49 coeff_irrigation Irrigation : 0.02904 coeff_nitrogen : 0.1
dfbiais = read.table("Drip_Fertigation_biais.csv", sep=";",header=T)
dfbiais$treat = ifelse(dfbiais$Drip=="Yes",1,0)

################################################################################
# Step 1. modeling yield according to data - 1st yield model g()
model_yield = lm(Yield ~ Drip + Irrigation + Nitrogen, data = dfbiais)

################################################################################
# Step 2. make new prediction on balanced data
# New data = balanced data
DripYes = dfbiais
DripNo = dfbiais
DripYes$Drip="Yes"
DripNo$Drip="No"

# Prediction of model values
DripYes$yieldpredict = predict(model_yield, newdata = DripYes)
DripNo$yieldpredict = predict(model_yield, newdata = DripNo)

################################################################################
# Step 3. The result : comparison of the means of our variable of interest between the two populations of individuals
# Average difference in predictions
mean(DripYes$yieldpredict) - mean(DripNo$yieldpredict)

################################################################################
# Step 4. not shown - As other methods, a bootstrap can be set to obtain a confidence interval for the estimate.


# end of file

