# Estimation of a causal effect of an agricultural practice based on observational data
# Korgan Aldebert (Acta), François Brun (Acta), David Makowski (Inrae), 2023-12-18
# Fertigation data : part 0 (just for info). Simulation of a fertigation data set

library(dplyr)
library(lme4)
# Loading all original fertigation data. Name and unit adapted from meta-analysis data from Haoru Li (2021, https://doi.org/10.1016/j.agwat.2020.106534)
# Study : identification of the original study (1:130)
# Nrate : N rate (kg ha-1)
# Irrigation : Irrigation amount (mm)
# Yield : Crop yield (ton ha-1))
# Crop : Crop type
# Drip : Drip (Yes/No)
df=read.table("Drip_Fertigation_all.csv", sep=";",header=T)
str(df)
df= df %>% filter(Crop=="Tomato" & !is.na(Irrigation))

summary(df)

modele = lmer(Yield ~ Drip + Irrigation + (1|Study), data = df)
summary(modele)

## extract fixed coefficients
intercept = fixef(modele)["(Intercept)"]
coeff_Drip =  fixef(modele)["DripYes"]
coeff_irrigation = fixef(modele)["Irrigation"]
# the 0.10 coefficient de 0.10 correspond to an added nitrogen  (N) effect
coeff_nitrogen = 0.10

# Les coefficients de DripYes et Irrigation
set.seed(1234)

# creating a larger data set, with a bias
dfbiais = data.frame()
sample_size = 500

for (i in 1:sample_size){
  Drip = ifelse(i %% 2 == 0, "No", "Yes")
  if (Drip == "No"){
    # bias : higher irrigation without Drip
    Irrigation = round(runif(1, 350, 600))
    # bias : higher nitrogen without Drip
    Nitrogen = round(runif(1, 100, 300))
    Yield = round(intercept + coeff_irrigation * Irrigation + coeff_nitrogen * Nitrogen + rnorm(1, 0, 5))
    }  else {
    Irrigation = round(runif(1, 150, 450))
    Nitrogen = round(runif(1, 0, 300))
    Yield = round(intercept + coeff_Drip + coeff_irrigation * Irrigation + coeff_nitrogen * Nitrogen + rnorm(1, 0, 5))
  }
  Yield = max(Yield, 0)
  obs = data.frame(Drip=Drip, Irrigation=Irrigation,Nitrogen=Nitrogen, Yield=Yield)
  dfbiais = rbind(dfbiais, obs)
}

write.table(dfbiais, "Drip_Fertigation_biais.csv",sep=";", row.names = FALSE)

# end of file